#include <iostream>
#include <string>
#include <cstdlib>
#include <cstdio>
#include <algorithm>
#include <map>
#include <set>
#include <vector>
#include <cmath>
#include <cstring>
#include <queue>
#include <deque>

#define mp make_pair
#define mt(a, b, c) mp(a, mp(b, c))
#define ABS(a) ((a > 0) ? (a) : (-a))
#define ZERO(x) memset((x), 0, sizeof(x))
#define X first
#define Y second

using namespace std;
typedef long long ll;
typedef unsigned long long ull;

const ll M = 1e9 + 7;

const int N = 2010;
ll dp[N][N];

int n, x;
ll d;

ll S[N];

ll binpow(ll n, int deg)
{
	if (deg == 0) return 1;
	if (deg % 2 == 0)
	{
		ll b = binpow(n, deg / 2);
		return (b * b) % M;
	}
	return (binpow(n, deg - 1) * n) % M;
}

ll fact[N];
ll inv_fact[N];

ll comb(ll n, ll k)
{
	if (k > n || k < 0)
		return 0;
	if (k == 0 || k == n)
		return 1;
	ll p = 1;
	for (ll i = n; i >= n - k + 1; i--)
		p = (p * (i % M)) % M;
	return (p * inv_fact[k]) % M;
}

int main()
{
	freopen("input.txt", "r", stdin);
	freopen("output.txt", "w", stdout);

	fact[0] = 1;
	for (ll i = 1; i < N; i++)
	{
		fact[i] = (fact[i - 1] * i) % M;
		inv_fact[i] = binpow(fact[i], M - 2);
	}

	while(1)
	{
		cin >> n >> d >> x;
		if (n == 0 && d == 0 && x == 0)
			break;

		for (int i = 0; i < N; i++)
			for (int j = 0; j < N; j++)
				dp[i][j] = 0;

		dp[0][n] = 1;

		for (int i = 0; i <= n + 2; i++)
		{
			S[i] = dp[0][i];
			if (i)
				S[i] += S[i - 1];
		}

		for (int i = 1; i <= n; i++)
		{
			for (int j = 0; j < n; j++)
			{
				int max_value = min(n + 2, x - 1 + j);
				int min_value = min(j + 1, n + 2);
				dp[i][j] = S[max_value] - S[min_value - 1];
				dp[i][j] %= M;
			}
			for (int j = 0; j <= n + 2; j++)
			{
				S[j] = dp[i][j];
				if (j)
					S[j] += S[j - 1];
			}
		}

		ll ans = 0;

		for (int i = 0; i <= n; i++)
		{
			if (dp[i][0] == 0) continue;
			if (i > d) break;
			ans += comb(d, i) * dp[i][0];
			ans %= M;
		}

		cout << ans << endl;
	}

	return 0;
}